#include "front_end.h"
#include "tokenizer.h"
#include "wam.h"

void Front_End::interactive()
{
	using namespace lp;
	// Print hello message
	cout << "Welcome to " << PROG_NAME << " version " << PROG_VERSION << ", by John Ahlgren <" <<
		AUTHOR_EMAIL << ">\n";

	string input;
	for (;;) {
		try {
			cin.sync();
			std::set<id_type> qvars;
			long long linec = 0;
			cout << "?- " << flush;
			std::unique_ptr<Functor> expr( stream_to_expr(std::cin,linec,qvars,lp::prolog_dic) );

			//std::unique_ptr<Functor> cpy( expr->copy() );
			//std::cerr << "Copy: " << *cpy << "\n";
			//std::cerr << "Post-order traversal:\n";
			//std::for_each(expr->post_begin(),expr->post_end(),[&](const Functor& n){ std::cerr << "  " << n << "\n"; });
			//std::cerr << "-------\n";

			if (!expr) {
				// EOF received
				throw destruct_and_exit();
			}

			Functor q(if_id,expr.release());
			this->query(q,qvars);
		} catch (const parse_error& err) {
			cerr << "Parse error: " << err.what() << "\n";
			cin.sync(); // flush input stream
			cin.clear(); // set good flag
		}
	} // for loop
}

int Front_End::query(const lp::Functor& q, const std::set<lp::id_type>& qvars)
{
	// Query, compute answers
	const int stat = kb.query(q,qvars);
	//std::cerr << "Query done\n";
	if (stat < 1) {
		cout << "No." << endl;
		return false;
	}
	return true;
}

